<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class InternalGuide extends Model
{
    use HasFactory;
    protected $table = "tbl_internal_guide";
    protected $fillable = [
        'correlative',
        'date',
        'operation',
        'idstore',
        'iddocument',
        'folio',
        'idsupplier',
        'idcompany',
        'internal_number',
        'observation',
        'observation_cancellation',
        'total',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->where('idcompany', request('idcompany'));
    }

    # Relaciones
    public function store(): HasOne
    {
        return $this->hasOne(Store::class, 'id', 'idstore');
    }

    public function document(): HasOne
    {
        return $this->hasOne(DocumentOfSale::class, 'id', 'iddocument');
    }

    public function supplier(): HasOne
    {
        return $this->hasOne(Supplier::class, 'id', 'idsupplier');
    }

    public function internalGuideDetail(): HasMany
    {
        return $this->hasMany(InternalGuideDetail::class, 'idinternal_guide', 'id')->where('status', 1);
    }

    # Filtros
    public function scopeInternalGuideFilters($query)
    {
        #Filtro de correlativo
        $query->when(
            request('correlative'),
            fn ($query) => $query->where('correlative', 'LIKE', '%' . request('correlative') . '%')
        );

        #Filtro de fechas
        $query->when(
            request('start_date') && request('end_date'),
            function ($query) {
                $start_date = request('start_date');
                $end_date = request('end_date');

                $query->whereBetween('date', [$start_date, $end_date]);
            }
        );

        #Filtro de operación
        $query->when(
            request('operation'),
            fn ($query) => $query->where('operation', request('operation'))
        );

        #Filtro de bodegas
        $query->when(
            request('idstore'),
            fn ($query) => $query->where('idstore', request('idstore'))
        );

        #Filtro de compañía
        $query->when(
            request('company'),
            fn ($query) => $query->where('idcompany', request('company'))
        );

        #Filtro de tipo de documento
        $query->when(
            request('iddocument'),
            fn ($query) => $query->where('iddocument', request('iddocument'))
        );

        #Filtro de tipo de proveedor
        $query->when(
            request('idsupplier'),
            fn ($query) => $query->where('idsupplier', request('idsupplier'))
        );

        #Filtro de tipo de folio o número interno
        $query->when(
            request('folioOrInternalNumber'),
            fn ($query) => $query->where('folio', request('folioOrInternalNumber'))
                ->orWhere('internal_number', request('folioOrInternalNumber'))
        );

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
