<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class InitialStep extends Model
{
    use HasFactory;

    protected $table = "tbl_initial_step";
    protected $primaryKey = "id";

    protected $fillable = [
        'description',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    #Relaciones
    public function detInitialStep() : HasMany
    {
        return $this->hasMany(DetInitialStep::class, 'idinitial_step', 'id');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Filtros
    public function scopeInitialStepFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('description', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de nombre de descripcion
        $query->when(
            request('description'),
            fn ($query) => $query->where('description', 'LIKE', '%' . request('description') . '%')
        );

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );
    }
}
