<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Model;


class DocumentOfSaleForCompany extends Model
{
    use HasFactory;
    protected $table = "tbl_document_of_sale_for_company";

    protected $fillable = [
        'iddocument_of_sale',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    #Relaciones
    public function documentOfSale(): HasOne
    {
        return $this->hasOne(DocumentOfSale::class, 'id', 'iddocument_of_sale');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeDocumentSale($query, $documentSale, $id = null)
    {
        return $query->when($id,
            fn ($query) => $query->where('id', '<>', $id))->where('iddocument_of_sale', $documentSale)->company();
    }

    # Filtros
    public function scopeDocumentFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->whereHas('documentOfSale',
                fn ($q) => $q->where('name', 'LIKE', '%' . request('search') . '%'))
        );

        #Filtro de id de documento de venta
        $query->when(
            request('iddocument_of_sale'),
            fn ($query) => $query->where('iddocument_of_sale', request('iddocument_of_sale'))
        );

        #Filtro de compañia
        $query->company();

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );
    }

}
