<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class DetailUserCompany extends Model
{
    use HasFactory;
    protected $table = 'tbl_detail_user_company';

    protected $fillable = [
        'iduser',
        'iduser_type',
        'idprivilege',
        'idcompany',
        'status_confirm',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'iduser');
    }

    public function userType(): HasOne
    {
        return $this->hasOne(UserType::class, 'id', 'iduser_type');
    }

    public function privilege(): HasOne
    {
        return $this->hasOne(Privilege::class, 'id', 'idprivilege');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeFindUser($query, $iduser, $type, $id = null)
    {
        return $query->when($id,
        fn ($query) => $query->where('id', '<>', $id))
            ->where('iduser', $iduser)->where('iduser_type', $type)->company();
    }

    # Filtros
    public function scopeUserCompanyFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->whereHas('user',
                fn ($q) => $q->where('rut', 'LIKE', '%' . request('search') . '%')
                    ->orWhere('username', 'LIKE', '%' . request('search') . '%'))
        );

        #Filtro de id usuario
        $query->when(
            request('iduser'),
            fn ($query) => $query->where('iduser', request('iduser'))
        );

        #Filtro de tipo de usuario
        $query->when(
            request('iduser_type'),
            fn ($query) => $query->where('iduser_type', request('iduser_type'))
        );

        #Filtro de privilegio
        $query->when(
            request('idprivilege'),
            fn ($query) => $query->where('idprivilege', request('idprivilege'))
        );

        #Filtro de estado de confirmación
        $query->when(
            request('status_confirm'),
            fn ($query) => $query->where('status_confirm', request('status_confirm'))
        );

        #Filtro de compañia
        $query->company();

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
