<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class DetailShoppingCart extends Model
{
    use HasFactory;

    protected $table = "tbl_detail_shopping_cart";

    protected $fillable = [
        'idshopping_cart',
        'idpricelist_product',
        'idproduct',
        'quantity',
        'price',
        'offer_price',
        'discount',
        'discounttype',
        'gross_subtotal',
        'net_subtotal',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    #Relaciones
    public function shoppingCart(): HasOne
    {
        return $this->hasOne(ShoppingCart::class, 'id', 'idshopping_cart');
    }

    public function product(): HasOne
    {
        return $this->hasOne(DetailPriceListProduct::class, 'id', 'idpricelist_product');
    }

    public function productOrigin(): HasOne
    {
        return $this->hasOne(Product::class, 'id', 'idproduct');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeProductShoppingCart($query, $shopping_cart, $pricelist_product, $type)
    {
        if ($type == 1) return $query->where('idshopping_cart', $shopping_cart)->where('idpricelist_product', $pricelist_product);

        return $query->where('idshopping_cart', $shopping_cart)->where('idproduct', $pricelist_product);
    }

    # Filtros
    public function scopeDetailShoppingCartFilters($query)
    {
        #Filtro de carrito de compras
        $query->when(
            request('idshopping_cart'),
            fn ($query) => $query->where('idshopping_cart', request('idshopping_cart'))
        );

        #Filtro de producto
        $query->when(
            request('idpricelist_product'),
            fn ($query) => $query->where('idpricelist_product', request('idpricelist_product'))
        );

        #Filtro de producto origen
        $query->when(
            request('idproduct'),
            fn ($query) => $query->where('idproduct', request('idproduct'))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
