<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class DetailPriceListSegment extends Model
{
    use HasFactory;
    protected $table = 'tbl_detail_pricelist_segments';

    protected $fillable = [
        'idpricelist',
        'idsegment',
        'idcompany',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function pricelist(): HasOne
    {
        return $this->hasOne(PriceList::class, 'id', 'idpricelist');
    }

    public function segment(): HasOne
    {
        return $this->hasOne(Segment::class, 'id', 'idsegment');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeSegmentID($query, $pricelist, $segment, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('idpricelist', $pricelist)->where('idsegment', $segment)->company();
    }

    # Filtros
    public function scopePriceListSegmentFilters($query)
    {
        #Filtro de precio de lista
        $query->when(
            request('idpricelist'),
            fn ($query) => $query->where('idpricelist', request('idpricelist'))
        );

        #Filtro de segmento
        $query->when(
            request('idsegment'),
            fn ($query) => $query->where('idsegment', request('idsegment'))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
