<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class DetailPriceListBranchOffice extends Model
{
    use HasFactory;
    protected $table = 'tbl_detail_pricelist_branchoffice';

    protected $fillable = [
        'idpricelist',
        'idbranchoffice',
        'idcompany',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function pricelist(): HasOne
    {
        return $this->hasOne(PriceList::class, 'id', 'idpricelist');
    }

    public function branchOffice(): HasOne
    {
        return $this->hasOne(BranchOffice::class, 'id', 'idbranchoffice');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeBranchOfficeID($query, $pricelist, $branchoffice, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('idpricelist', $pricelist)->where('idbranchoffice', $branchoffice)->company();
    }

    # Filtros
    public function scopePriceListBranchOfficeFilters($query)
    {
        #Filtro de precio de lista
        $query->when(
            request('idpricelist'),
            fn ($query) => $query->where('idpricelist', request('idpricelist'))
        );

        #Filtro de sucursal
        $query->when(
            request('idbranchoffice'),
            fn ($query) => $query->where('idbranchoffice', request('idbranchoffice'))
        );

        #Filtro de distrito
        $query->when(
            request('iddistrict'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('iddistrict', request('iddistrict')))
        );

        #Filtro de provincia
        $query->when(
            request('idprovince'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('idprovince', request('idprovince')))
        );

        #Filtro de departamento
        $query->when(
            request('iddepartment'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('iddepartment', request('iddepartment')))
        );

        #Filtro de pais
        $query->when(
            request('idcountry'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('idcountry', request('idcountry')))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
