<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class DetailMembershipPayment extends Model
{
    use HasFactory;

    protected $table = 'tbl_detail_membership_payment';

    public $timestamps = false;

    protected $fillable = [
        'idcompany',
        'idmembershipcosts',
        'idpay',
        'payment_date',
        'payment_date_end',
        'status_page',
        'status_invoice',
        'url_invoice',
        'status'
    ];

    # Relaciones
    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    public function membershipCosts(): HasOne
    {
        return $this->hasOne(MembershipCosts::class, 'id', 'idmembershipcosts');
    }

    public function pay(): HasOne
    {
        return $this->hasOne(Pay::class, 'id', 'idpay');
    }

    # Query scopes
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
