<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Department extends Model
{
    use HasFactory;

    protected $table = 'tbl_department';

    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'name',
        'idcountry',
        'idtimezone',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function country(): HasOne
    {
        return $this->hasOne(Country::class, 'id', 'idcountry');
    }

    public function province(): HasOne
    {
        return $this->hasOne(Province::class, 'iddepartment', 'id');
    }

    public function timeZone(): HasOne
    {
        return $this->hasOne(TimeZone::class, 'id', 'idtimezone');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    # Filtros
    public function scopeDepartmentFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('search') . '%')
                ->orWhere('name', 'LIKE', '%' . request('search') . '%')
        );

        #Filtro de codigo
        $query->when(
            request('code'),
            fn ($query) => $query->where('code', 'LIKE', '%' . request('code') . '%')
        );

        #Filtro de nombre
        $query->when(
            request('name'),
            fn ($query) => $query->where('name', 'LIKE', '%' . request('name') . '%')
        );

        #Filtro de pais
        $query->when(
            request('idcountry'),
            fn ($query) => $query->where('idcountry', request('idcountry'))
        );

        #Filtro de timezone
        $query->when(
            request('idtimezone'),
            fn ($query) => $query->where('idtimezone', request('idtimezone'))
        );

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
