<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class CustomerWallet extends Model
{
    use HasFactory;

    protected $table = "tbl_customer_wallet";

    protected $fillable = [
        'description',
        'idsupplier',
        'idsalesman',
        'idaccount_status',
        'relationship_date',
        'last_purchase',
        'goal',
        'idbranchoffice',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    #Relaciones
    public function supplier(): HasOne
    {
        return $this->hasOne(Supplier::class, 'id', 'idsupplier');
    }

    public function salesman(): HasOne
    {
        return $this->hasOne(Salesman::class, 'id', 'idsalesman');
    }

    public function account_status(): HasOne
    {
        return $this->hasOne(AccountStatus::class, 'id', 'idaccount_status');
    }

    public function branchOffice(): HasOne
    {
        return $this->hasOne(BranchOffice::class, 'id', 'idbranchoffice');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    public function scopeCustomerWalletID($query, $supplier, $salesman, $id = null)
    {
        return $query->when($id, fn ($query) => $query->where('id', '<>', $id))->where('idsupplier', $supplier)->where('idsalesman', $salesman)->company();
    }

    # Filtros
    public function scopeCustomerWalletFilters($query)
    {
        #Filtro de cliente
        $query->when(
            request('idsupplier'),
            fn ($query) => $query->where('idsupplier', request('idsupplier'))
        );

        #Filtro de vendedor
        $query->when(
            request('idsalesman'),
            fn ($query) => $query->where('idsalesman', request('idsalesman'))
        );

        #Filtro de estado de cuenta
        $query->when(
            request('idaccount_status'),
            fn ($query) => $query->where('idaccount_status', request('idaccount_status'))
        );

        #Filtro de fecha de relacion
        $query->when(
            request('relationship_date'),
            fn ($query) => $query->where('relationship_date', request('relationship_date'))
        );

        #Filtro de última compra
        $query->when(
            request('last_purchase'),
            fn ($query) => $query->where('last_purchase', request('last_purchase'))
        );

        #Filtro de meta
        $query->when(
            request('goal'),
            fn ($query) => $query->where('goal', request('goal'))
        );

        #Filtro de sucursal
        $query->when(
            request('idbranchoffice'),
            fn ($query) => $query->where('idbranchoffice', request('idbranchoffice'))
        );

        #Filtro de distrito
        $query->when(
            request('iddistrict'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('iddistrict', request('iddistrict')))
        );

        #Filtro de provincia
        $query->when(
            request('idprovince'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('idprovince', request('idprovince')))
        );

        #Filtro de departamento
        $query->when(
            request('iddepartment'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('iddepartment', request('iddepartment')))
        );

        #Filtro de pais
        $query->when(
            request('idcountry'),
            fn ($query) => $query->whereHas('branchOffice',
                fn ($q) => $q->where('idcountry', request('idcountry')))
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
