<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class CompanyDefaultPermissions extends Model
{
    use HasFactory;
    protected $table = 'tbl_company_default_permissions';

    protected $fillable = [
        'idcompany',
        'iduser_type',
        'permissions',
        'status',
    ];

    protected $casts = [
        'permissions' => 'array'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function userType(): HasOne
    {
        return $this->hasOne(UserType::class, 'id', 'iduser_type');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    # Filtros
    public function scopeCompanyDefaultPermissionsFilters($query)
    {
        #Filtro de compañía
        $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );

        #Filtro de tipo de usuario
        $query->when(
            request('iduser_type'),
            fn ($query) => $query->where('iduser_type', request('iduser_type'))
        );

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }
}
