<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ClientAddress extends Model
{
    use HasFactory;
    protected $table = "tbl_client_address";
    protected $primaryKey = "id";

    protected $fillable = [
        'address',
        'email',
        'idclient',
        'idcountry',
        'iddepartment',
        'idprovince',
        'iddistrict',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function country(): HasOne
    {
        return $this->hasOne(Country::class, 'id', 'idcountry');
    }

    public function department(): HasOne
    {
        return $this->hasOne(Department::class, 'id', 'iddepartment');
    }

    public function province(): HasOne
    {
        return $this->hasOne(Province::class, 'id', 'idprovince');
    }

    public function district(): HasOne
    {
        return $this->hasOne(District::class, 'id', 'iddistrict');
    }

    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    # Filtros
    public function scopeFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            fn ($query) => $query->where('address', '%' . request('search') . '%')
        );

        #Filtro de address
        $query->when(
            request('address'),
            fn ($query) => $query->where('address', 'LIKE', '%' . request('address') . '%')
        );
     
        #Filtro de idcliente
        $query->when(
            request('idclient'),
            fn ($query) => $query->where('idclient', 'LIKE', '%' . request('idclient') . '%')
        );
       
        #Filtro de email
        $query->when(
            request('email'),
            fn ($query) => $query->where('email', 'LIKE', '%' . request('email') . '%')
        );

        #Filtro de lista de país
        $query->when(
            request('idcountry'),
            fn ($query) => $query->where('idcountry', request('idcountry'))
        );

        #Filtro de departamento
        $query->when(
            request('iddepartment'),
            fn ($query) => $query->where('iddepartment', request('iddepartment'))
        );

        #Filtro de provincia
        $query->when(
            request('idprovince'),
            fn ($query) => $query->where('idprovince', request('idprovince'))
        );

        #Filtro de distrito
        $query->when(
            request('iddistrict'),
            fn ($query) => $query->where('iddistrict', request('iddistrict'))
        );

        #Filtro de dirección
        $query->when(
            request('address'),
            fn ($query) => $query->where('address', 'LIKE', '%' . request('address') . '%')
        );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status'),
            fn ($query) => $query->where('status', request('status'))
        )->when(
            !request('status'),
            fn ($query) => $query->where('status', 1)
        );

    }
}
