<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Bank extends Model
{
    use HasFactory;
    protected $table = "tbl_bank";

    public $timestamps = false;

    protected $fillable = [
        'name',
        'code_SBIF',
        'idcountry',
        'status'
    ];

    # Relaciones
    public function country(): HasOne
    {
        return $this->hasOne(Country::class, 'id', 'idcountry');
    }

    # Filtros
    public function scopeBankFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            function ($query) {
                $search = request('search');
                $query->where(function ($q) use ($search) {
                    $q->where('name', 'LIKE', '%' . $search . '%');
                });
            }
        );

        #Filtro de país
        $query->when(
            request('idcountry'),
            fn ($query) => $query->where('idcountry', request('idcountry'))
        );
    }
}
