<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AdminCompany extends Model
{
    use HasFactory;
    protected $table = "tbl_admin_company";

    protected $fillable = [
        'rut',
        'name',
        'surname',
        'email',
        'phone',
        'address',
        'birth_date',
        // 'idcharge_erp',
        'idcompany',
        'status'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    # Relaciones
    public function company(): HasOne
    {
        return $this->hasOne(Company::class, 'id', 'idcompany');
    }

    # Query scopes
    public function scopeActiveForID($query, $id)
    {
        return $query->where('id', $id)->where('status', 1)->company();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeCompany($query)
    {
        return $query->when(
            request('idcompany'),
            fn ($query) => $query->where('idcompany', request('idcompany'))
        );
    }

    // public function scopeChargeERP($query, $idcharge)
    // {
    //     return $query->where('idcharge_erp', $idcharge);
    // }

    # Filtros
    public function scopeAdminFilters($query)
    {
        #Filtro de Buscador
        $query->when(
            request('search'),
            function ($query) {
                $search = request('search');
                $query->where(function ($q) use ($search) {
                    $q->where('rut', 'LIKE', '%' . $search . '%')
                        ->orWhere('name', 'LIKE', '%' . $search . '%')
                        ->orWhere('surname', 'LIKE', '%' . $search . '%');
                });
            }
        );

        #Filtro de RUT
        $query->when(
            request('rut'),
            fn ($query) => $query->where('rut', 'LIKE', '%' . request('rut') . '%')
        );

        #Filtro de name
        $query->when(
            request('name'),
            fn ($query) => $query->where('name', 'LIKE', '%' . request('name') . '%')
        );

        #Filtro de surname
        $query->when(
            request('surname'),
            fn ($query) => $query->where('surname', 'LIKE', '%' . request('surname') . '%')
        );

        #Filtro de email
        $query->when(
            request('email'),
            fn ($query) => $query->where('email', request('email'))
        );

        #Filtro de idcargo de ERP
        // $query->when(
        //     request('idcharge_erp'),
        //     fn ($query) => $query->where('idcharge_erp', request('idcharge_erp'))
        // );

        #Filtro de idcompany
        $query->company();

        #Filtro de estados
        $query->when(
            request('status') !== null,
            fn ($query) => $query->where('status', request('status'))
        )->when(
            request('status') === null,
            fn ($query) => $query->where('status', 1)
        );
    }

    public function scopeRut($query, $rut, $id = null)
    {
        return $query->when($id, function ($query) use ($id) {
            return $query->where('id', '<>', $id);
        })->where('rut', $rut)->company();
    }
}
