<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeCompanyFirstPayMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $company;
    protected $autoLogin;

    public function __construct($company, $autoLogin)
    {
        $this->company      = $company;
        $this->autoLogin    = $autoLogin;
    }

    public function build()
    {
        return $this->view('emails.welcomeCompany')
            ->subject('CORREO DE BIENVENIDA - FACTURADOR')
            ->with([
                'company'   => $this->company,
                'autoLogin' => $this->autoLogin
            ]);
    }
}
