<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SendCredentials extends Mailable
{
    use Queueable, SerializesModels;

    protected $user;
    protected $rut;
    protected $typeUser;
    protected $password;
    protected $url_autologin;

    public function __construct($user, $rut, $typeUser, $password, $url_autologin)
    {
        $this->user             = $user;
        $this->rut              = $rut;
        $this->typeUser         = $typeUser;
        $this->password         = $password;
        $this->url_autologin    = $url_autologin;
    }

    public function build()
    {
        return $this->view('emails.sendCredentials')
            ->subject('Envío de credenciales  - FACTURADOR')
            ->with([
                'user'          => $this->user,
                'rut'           => $this->rut,
                'typeUser'      => $this->typeUser,
                'password'      => $this->password,
                'url_autologin' => $this->url_autologin
            ]);
    }
}
