<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResendCredentialsMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $user;
    protected $rut;
    protected $typeUser;
    protected $password;
    protected $url_autologin;

    public function __construct($user, $rut, $typeUser, $password, $url_autologin)
    {
        $this->user             = $user;
        $this->rut              = $rut;
        $this->typeUser         = $typeUser;
        $this->password         = $password;
        $this->url_autologin    = $url_autologin;
    }

    public function build()
    {
        return $this->view('emails.resendCredentials')
            ->subject('Recuperación de credenciales - OT TVP')
            ->with([
                'user'          => $this->user,
                'rut'           => $this->rut,
                'typeUser'      => $this->typeUser,
                'password'      => $this->password,
                'url_autologin' => $this->url_autologin
            ]);
    }
}
