<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ProofPaymentMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $nameUser;
    protected $receiptNumber;
    protected $dueDate;
    protected $amount;

    public function __construct($nameUser, $receiptNumber, $dueDate, $amount)
    {
        $this->nameUser         = $nameUser;
        $this->receiptNumber    = $receiptNumber;
        $this->dueDate          = $dueDate;
        $this->amount           = $amount;
    }

    public function build()
    {
        return $this->view('emails.proofPayment')
            ->subject('EXPIRACIÓN DE COMPROBANTE DE PAGO - FACTURADOR')
            ->with([
                'nameUser'      => $this->nameUser,
                'receiptNumber' => $this->receiptNumber,
                'dueDate'       => $this->dueDate,
                'amount'        => $this->amount
            ]);
    }
}
