<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MembershipPay extends Mailable
{
    use Queueable, SerializesModels;

    protected $rut;
    protected $professionalName;
    protected $initialDate;
    protected $endDate;
    protected $countMonths;
    protected $payTotal;
    protected $rutaDocument;

    public function __construct($rut, $professionalName, $initialDate, $endDate, $countMonths, $payTotal, $rutaDocument)
    {
        $this->rut              = $rut;
        $this->professionalName = $professionalName;
        $this->initialDate      = $initialDate;
        $this->endDate          = $endDate;
        $this->countMonths      = $countMonths;
        $this->payTotal         = 'CLP ' . number_format($payTotal);
        $this->rutaDocument     = $rutaDocument;
    }

    public function build()
    {
        return $this->view('emails.successPayMembership')
            ->subject('Pago de membresía - FACTURADOR')
            ->with([
                'rut'               => $this->rut,
                'professionalName'  => $this->professionalName,
                'initialDate'       => $this->initialDate,
                'endDate'           => $this->endDate,
                'countMonths'       => $this->countMonths,
                'payTotal'          => $this->payTotal
            ])
            ->attach($this->rutaDocument);
    }
}
