<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MembershipOldExpiredMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $admin;
    protected $url;

    public function __construct($admin, $url)
    {
        $this->admin    = $admin;
        $this->url      = $url;
    }

    public function build()
    {
        return $this->view('emails.membershipOldExpired')
            ->subject('Membresía expirada - FACTURADOR')
            ->with([
                'admin' => $this->admin,
                'url'   => $this->url
            ]);
    }
}
