<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MembershipExpiredMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $admin;
    protected $url;

    public function __construct($admin, $url)
    {
        $this->admin    = $admin;
        $this->url      = $url;
    }

    public function build()
    {
        return $this->view('emails.membershipExpired')
            ->subject('Membresía por expirar - FACTURADOR')
            ->with([
                'admin' => $this->admin,
                'url'   => $this->url
            ]);
    }
}
