<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class MembershipChangeDefeatedMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $admin;
    protected $url;

    public function __construct($admin, $url)
    {
        $this->admin    = $admin;
        $this->url      = $url;
    }

    public function build()
    {
        return $this->view('emails.membershipChangeDefeated')
            ->subject('Cuenta vencida - FACTURADOR')
            ->with([
                'admin' => $this->admin,
                'url'   => $this->url
            ]);
    }
}
