<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ExpirationProofPaymentMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $nameAdmin;
    protected $date;
    protected $countProofPayment;
    protected $urlProofPayment;

    public function __construct($nameAdmin, $date, $countProofPayment, $urlProofPayment)
    {
        $this->nameAdmin            = $nameAdmin;
        $this->date                 = $date;
        $this->countProofPayment    = $countProofPayment;
        $this->urlProofPayment      = $urlProofPayment;
    }

    public function build()
    {
        return $this->view('emails.expirationProofPayment')
            ->subject('EXPIRACIÓN DE COMPROBANTES DE PAGO - FACTURADOR')
            ->with([
                'nameAdmin'         => $this->nameAdmin,
                'date'              => $this->date,
                'countProofPayment' => $this->countProofPayment,
                'urlProofPayment'   => $this->urlProofPayment
            ]);
    }
}
