<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WaytopayByCompanyResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $wayToPay = $this->relationLoaded('wayToPay') ? $this->whenLoaded('wayToPay') : null;

        return [
            'id'=>$this->id,
            'idtools'=>$this->idtools,
            'cuotas' => $this->cuotas,
            'idcuotas' => $this->idcuotas,
            'idway_to_pay' => $this->idway_to_pay,
            $this->mergeWhen($wayToPay, fn() => [
                'wayToPay' => $wayToPay->name,
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
