<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $userType = $this->relationLoaded('userType') ? $this->whenLoaded('userType') : null;
        $privilege = $this->relationLoaded('privilege') ? $this->whenLoaded('privilege') : null;
        $companies = $this->relationLoaded('companies') ? $this->whenLoaded('companies') : null;

        return [
            'id'=>$this->id,
            'rut'=>$this->rut,
            'name' => $this->name,
            'first_surname' => $this->first_surname,
            'second_surname' => $this->second_surname,
            'gender' => $this->gender,
            'type_person' => $this->type_person,
            'type_person_name' => $this->type_person == 0 ? 'Natural' : 'Jurídica',
            'idprivilege' => $this->idprivilege,
            $this->mergeWhen($privilege, fn() => [
                'privilege_name' => $privilege->name,
            ]),
            'age' => $this->age,
            'birthdate' => Carbon::parse($this->birthdate)->format('Y-m-d'),
            'email' => $this->email,
            'phone' => $this->phone,
            'iduser_type'=>$this->iduser_type,
            $this->mergeWhen($userType, fn() => [
                'type_user_name' => $userType->name,
            ]),
            'idcompanies' => $this->idcompanies,
            'status_confirm'=>$this->status_confirm,
            'status'=>$this->status
        ];
    }
}
