<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TicketResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $user       = $this->relationLoaded('user') ? $this->whenLoaded('user') : null;
        $customer   = $this->relationLoaded('customer') ? $this->whenLoaded('customer') : null;
        $company    = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $details    = $this->relationLoaded('detail') ? $this->whenLoaded('detail') : null;
        $pay        = $this->relationLoaded('pay') ? $this->whenLoaded('pay') : null;
        $typeSale = $this->relationLoaded('typeSale') ? $this->whenLoaded('typeSale') : null;
        $wayToPay = $this->relationLoaded('wayToPay') ? $this->whenLoaded('wayToPay') : null;
        $typeDocument = $this->relationLoaded('typeDocument') ? $this->whenLoaded('typeDocument') : null;
        $saleChannel = $this->relationLoaded('saleChannel') ? $this->whenLoaded('saleChannel') : null;

        return [
            'id'                    => $this->id,
            'date'                  => $this->date,
            'date_format'           => Carbon::parse($this->date)->isoFormat('D [de] MMMM [de] YYYY'),
            'nro_ticket'            => $this->nro_ticket,
            'iduser_created'        => $this->iduser_created,
            'status_invoice'        => $this->status_invoice,
            'issued_proof_payment'  => $this->issued_proof_payment,
            'proof_payment_amount'  => $this->proof_payment_amount,
            'url_invoice'           => $this->url_invoice,
            'folio'                 => $this->folio,
            'mnt_excent'            => $this->mnt_excent,
            'IVA'                   => round($this->IVA),
            'total_discount'        => round($this->total_discount),
            'sub_total'             => round($this->sub_total),
            'total'                 => round($this->total),
            $this->mergeWhen($user, fn() => [
                'rut_user_created'  => $user->rut,
            ]),
            'idcustomer'            => $this->idcustomer,
            $this->mergeWhen($customer, fn() => [
                'name_customer'     => $customer->name_rz,
                'rut_customer'      => $customer->rut,
                'giro_customer'     => $customer->giro,
                'address_customer'  => $customer->address ?? '',
                'district_customer' => $customer->district->name ?? '',
                'province_customer' => $customer->province->name ?? '',
                'country_customer'  => $customer->country->name ?? ''
            ]),
            'gross_total'           => round($this->gross_total),
            'net_total'             => round($this->net_total),
            'idtype_document'       => $this->idtype_document,
            $this->mergeWhen($typeDocument, fn() => [
                'type_document'     => $typeDocument->name,
            ]),
            'iudsale_channel'           => $this->iudsale_channel,
            $this->mergeWhen($saleChannel, fn() => [
                'saleChannel'         => $saleChannel->name,
            ]),
            'payment_condition'     => $this->payment_condition,
            'idway_to_pay'          => $this->idway_to_pay,
            $this->mergeWhen($wayToPay, fn() => [
                'way_to_pay'         => $wayToPay->name,
            ]),
            'status_ticket'         => $this->status_ticket,
            'payment_status'        => $this->payment_status,
            'payment_status_name'   => $this->payment_status == 1 ? 'Pagado': 'No pagado',
            $this->mergeWhen($this->payment_status == 1 && $pay, fn() => [
                'pay_amount'                => $pay->amount,
                'pay_purchase_identifier'   => $pay->purchase_identifier,
                'pay_creation_date'         => $pay->creation_date,
            ]) ?? [],
            'idcompany'             => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company'           => $company->business_name,
                'rut_company'       => $company->rut,
                'address_company'   => $company->address,
                'giro_company'      => $company->giro,
                'phone_company'     => $company->phone
            ]),
            'status'                => $this->status,
            'details'               => DetailTicketResource::collection($details),
        ];
    }
}
