<?php

namespace App\Http\Resources;

use App\Models\SupplierContact;
use App\Models\ClientAddress;
use App\Models\ClientSetting;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SupplierResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $wayToPay = $this->relationLoaded('wayToPay') ? $this->whenLoaded('wayToPay') : null;
        $segment = $this->relationLoaded('segment') ? $this->whenLoaded('segment') : null;
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;
        $department = $this->relationLoaded('department') ? $this->whenLoaded('department') : null;
        $province = $this->relationLoaded('province') ? $this->whenLoaded('province') : null;
        $district = $this->relationLoaded('district') ? $this->whenLoaded('district') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        $contacts = SupplierContact::where('idsupplier', $this->id)->active()->get() ?? [];
        $clientAddresses = ClientAddress::where('idclient', $this->id)->active()->get() ?? [];
        $clientSetting = ClientSetting::where('idclient', $this->id)->active()->first() ?? null;

        return [
            'id' => $this->id,
            'rut' => $this->rut,
            'name_rz' => $this->name_rz,
            'fantasy_name' => $this->fantasy_name,
            'web' => $this->web,
            'giro' => $this->giro,
            'email' => $this->email,
            'phone' => $this->phone,
            'fax' => $this->fax,
            'type' => $this->type,
            'legal_nature' => $this->legal_nature,           
            $this->mergeWhen($wayToPay, fn() => [
                'idwaytopay' => $wayToPay->id,
                'waytopay' => $wayToPay->name
            ]),
            $this->mergeWhen($segment, fn() => [
                'idsegment' => $segment->id,
                'segment' => $segment->name
            ]),
            $this->mergeWhen($country, fn() => [
                'idcountry' => $country->id,
                'country' => $country->name
            ]),
            $this->mergeWhen($department, fn() => [
                'iddepartment' => $department->id,
                'department' => $department->name
            ]),
            $this->mergeWhen($province, fn() => [
                'idprovince' => $province->id,
                'province' => $province->name
            ]),
            $this->mergeWhen($district, fn() => [
                'iddistrict' => $district->id,
                'district' => $district->name
            ]),
            'address' => $this->address,
            $this->mergeWhen($company, fn() => [
                'idcompany' => $company->id,
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'contacts' => $contacts,
            'clientAddresses' => ClientAddressResource::collection($clientAddresses->load('country','department', 'province', 'district')),
            'clientSetting' => $clientSetting,
            'status' => $this->status
        ];
    }
}
