<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StoreResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $branchOffice = $this->relationLoaded('branchOffice') ? $this->whenLoaded('branchOffice') : null;
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;
        $department = $this->relationLoaded('department') ? $this->whenLoaded('department') : null;
        $province = $this->relationLoaded('province') ? $this->whenLoaded('province') : null;
        $district = $this->relationLoaded('district') ? $this->whenLoaded('district') : null;

        return [
            'id'=>$this->id,
            'code'=>$this->code,
            'name' => $this->name,
            'description' => $this->description,
            'address' => $this->address,
            'idbranchoffice' => $this->idbranchoffice,
            $this->mergeWhen($branchOffice, fn() => [
                'branchOffice' => $branchOffice->name,
            ]),
            'idcountry' => $this->idcountry,
            $this->mergeWhen($country, fn() => [
                'country' => $country->name,
            ]),
            'iddepartment' => $this->iddepartment,
            $this->mergeWhen($department, fn() => [
                'department' => $department->name,
            ]),
            'idprovince' => $this->idprovince,
            $this->mergeWhen($province, fn() => [
                'province' => $province->name,
            ]),
            'iddistrict' => $this->iddistrict,
            $this->mergeWhen($province, fn() => [
                'district' => $district->name,
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
