<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShoppingCartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $user = $this->relationLoaded('user') ? $this->whenLoaded('user') : null;
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'=>$this->id,
            'iduser_created' => $this->iduser_created,
            $this->mergeWhen($user, fn() => [
                'rut_user' => $user->rut,
                'username' => $user->username,
                'name' => $user->name,
                'first_surname' => $user->first_surname,
                'second_surname' => $user->second_surname,
                'gender' => $user->gender,
                'type_person' => $user->type_person,
                'age' => $user->age,
                'birthdate' => $user->birthdate,
                'email' => $user->email,
                'phone' => $user->phone,
                'status_customer' => $user->status,
                'birthdate' => $user->birthdate,
            ]),
            'idcustomer' => $this->idcustomer,
            $this->mergeWhen($customer, fn() => [
                'rut_customer' => $customer->rut,
                'name_customer' => $customer->name_rz,
                'email_customer' => $customer->email,
                'phone_customer' => $customer->phone
            ]),
            'documenttype' => $this->documenttype,
            'global_discount' => $this->global_discount,
            'discounttype' => $this->discounttype,
            'gross_total' => $this->gross_total,
            'total_discount' => round($this->total_discount),
            'sub_total' => round($this->sub_total),
            'net_total' => round($this->net_total),
            'IGV' => round($this->IGV),
            'total' => round($this->total),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'quantity_product' => count($this->detail),
            'detail' => DetailShoppingCartResource::collection($this->detail->load('product', 'productOrigin')),
            'status_ticket' => $this->status_ticket,
            'status'=>$this->status
        ];
    }
}
