<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SalesmanResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $channel = $this->relationLoaded('channel') ? $this->whenLoaded('channel') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'            => $this->id,
            'rut'           => $this->rut,
            'name'          => $this->name,
            'surname'       => $this->surname,
            'gender'        => $this->gender,
            'type_person'   => $this->type_person,
            'age'           => $this->age,
            'birthdate'     => $this->birthdate,
            'address'       => $this->address,
            'email'         => $this->email,
            'phone'         => $this->phone,
            'idchannel' => $this->idchannel,
            $this->mergeWhen($channel, fn() => [
                'productlist' => $channel->name,
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
