<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SaleChannelResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'name' => $this->name,
            $this->mergeWhen($company, fn() => [
                'idcompany' => $company->id,
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
