<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReferenceDocumentsResource extends JsonResource
{
    
    public function toArray(Request $request): array
    {
        $documentofsale = $this->relationLoaded('documentofsale') ? $this->whenLoaded('documentofsale') : null;
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'=>$this->id,
            'folio'=>$this->folio,
            'description' => $this->description,

            'iddocument_of_sale' => $this->iddocument_of_sale,
            $this->mergeWhen($documentofsale, fn() => [
                'document' => $documentofsale->name,
            ]),

            'idcustomer' => $this->idcustomer,
            $this->mergeWhen($customer, fn() => [
                'customer' => $customer->name_rz,
            ]),

            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),

            'status'=>$this->status
        ];
    }
}
