<?php

namespace App\Http\Resources;

use App\Models\Ticket;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProofPaymentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $company            = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $userCreated        = $this->relationLoaded('userCreated') ? $this->whenLoaded('userCreated') : null;
        $acceptedUser       = $this->relationLoaded('acceptedUser') ? $this->whenLoaded('acceptedUser') : null;
        $wayToPayForCompany = $this->relationLoaded('wayToPayForCompany') ? $this->whenLoaded('wayToPayForCompany') : null;

        // Verificar si requiere o no  validación bajo la configuración de la empresa
        $paymentValidation = $company->companyConfiguration->payment_validation;
        $valuePaymentValidation = false;
        if (is_null($this->accepted_iduser) && $paymentValidation == 1) {
            $valuePaymentValidation = true;
        }

        return [
            'id'                    => $this->id,
            'idcompany'             => $this->idcompany,
            $this->mergeWhen($company, fn () => [
                'company_name'      => $company->business_name,
                'company_rut'       => $company->rut
            ]),
            'payment_method'        => $this->payment_method,
            'idway_to_pay_for_company'          => $this->idway_to_pay_for_company,
            $this->mergeWhen($wayToPayForCompany, fn () => [
                'way_to_pay_for_company_name'   => $wayToPayForCompany->wayToPay->name
            ]),
            'idstickets'            => TicketResource::collection(Ticket::whereIn('id', $this->idstickets)->get()->load('user', 'customer', 'detail', 'pay', 'typeSale', 'wayToPay', 'typeDocument')),
            'iduser_created'        => $this->iduser_created,
            $this->mergeWhen($userCreated, fn () => [
                'user_created_rut'  => $userCreated->rut
            ]),
            'date_admission'        => $this->date_admission,
            'document_date'         => $this->document_date,
            'idbank'                => $this->idbank,
            'serie'                 => $this->serie,
            'amount'                => $this->amount,
            'amount_text'           => $this->amount_text,
            'unpaid_documents'      => $this->unpaid_documents,
            'date_creation'         => $this->date_creation,
            'authorized_quota'      => $this->authorized_quota,
            'used_quota'            => $this->used_quota,
            'available_space'       => $this->available_space,
            'expiration'            => $this->expiration,
            'document_url'          => $this->document_url,
            'accepted_iduser'       => $this->accepted_iduser,
            $this->mergeWhen($acceptedUser, fn () => [
                'accepted_user_rut' => $acceptedUser->rut
            ]),
            'requires_validation'   => $valuePaymentValidation,
            $this->mergeWhen($company, fn () => [
                'company_name'      => $company->business_name,
                'company_rut'       => $company->rut
            ]),
            'status'                => $this->status
        ];
    }
}
