<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductWithoutListResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'idproduct' => $this->id,
            'codeerp_product' => $this->code_erp,
            'codesystem_product' => $this->code_system,
            'name_product' => $this->name,

            'description_product' => $this->description,
            'cost_product' => $this->cost,
            'price_product' => $this->price,
            'alternativeprice_product' => $this->alternativeprice,
            'margin_product' => $this->margin,
            'offerprice_product' => $this->offerprice,
            'minimumstock_product' => $this->minimumstock,
            'maximumstock_product' => $this->maximumstock,

            'main_image_product' => $this->main_image,
            'optional_image1_product' => $this->optional_image1,
            'optional_image2_product' => $this->optional_image2,
            'optional_image3_product' => $this->optional_image3,
            'optional_image4_product' => $this->optional_image4,

            'idattributes_product' => $this->idattributes,
            'idspecificattributes_product' => $this->idspecificattributes,
            'iduses_product' => $this->iduses,
            'idspecificuses_product' => $this->idspecificuses,

            'idcointype_product' => $this->idcointype,
            'cointype_product' => $this->cointType->name ?? null,
            'idcategory_product' => $this->idcategory,
            'category_product' => $this->category->name ?? null,
            'idsubcategory_product' => $this->idsubcategory,
            'subcategory_product' => optional($this)->subcategory,
            'idspecificsubcategory_product' => $this->idspecificsubcategory,
            'specificsubcategory_product' => optional($this)->specificSubcategory,
            'idtype_product' => $this->idtype,
            'type_product' => optional($this)->type,
            'idsupplier_product' => $this->idsupplier,
            'idunitmeasure_product' => $this->idunitmeasure,
            'unitmeasure_product' => optional($this)->unitMeasure,
            'idunitmeasureoptional_product' => $this->idunitmeasureoptional,
            'idbusinessarea_product' => $this->idbusinessarea,
            'businessarea_product' => optional($this)->businessArea,
            'idclassification_product' => $this->idclassification,
            'classification_product' => optional($this)->classification,
            'relationProductAttributes' => optional($this)->relationProductAttributes,
            'idcompany' => $this->idcompany,
            'status' => $this->status
        ];
    }
}
