<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductClassificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $branchOffice = $this->relationLoaded('branchOffice') ? $this->whenLoaded('branchOffice') : null;

        return [
            'id' => $this->id,
            'name' => $this->name,
            $this->mergeWhen($branchOffice, fn() => [
                'idbranchoffice' => $branchOffice->id,
                'branch_office' => $branchOffice->name,
            ]),
            $this->mergeWhen($company, fn() => [
                'idcompany' => $company->id,
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
