<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PricelistResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $createdby = $this->relationLoaded('createdby') ? $this->whenLoaded('createdby') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id'=>$this->id,
            'code'=>$this->code,
            'name' => $this->name,
            'description' => $this->description,
            'creation_date' => $this->creation_date,
            'validity_date' => $this->validity_date,
            'document_state' => $this->document_state,
            'quantity_products' => $this->quantity_products,
            'total' => $this->total,
            'type' => $this->type,
            'discounttype' => $this->discounttype,
            'max_desc_item' => $this->max_desc_item,
            'max_desc_global' => $this->max_desc_global,
            'created_by' => $this->created_by,
            $this->mergeWhen($createdby, fn() => [
                // 'name_createdby' => ($createdby->name && $createdby->first_surname) ? $createdby->name . ' ' . $createdby->first_surname : '',
                'name_createdby' => $createdby->username ?? '',
            ]),

            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
            ]),
            'status'=>$this->status
        ];
    }
}
