<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PriceListProductResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $pricelist = $this->relationLoaded('pricelist') ? $this->whenLoaded('pricelist') : null;
        $product = $this->relationLoaded('product') ? $this->whenLoaded('product') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'price' => $this->price,
            'cost' => $this->cost,
            'stock' => $this->stock,
            'subtotal' => $this->subtotal,
            'discount' => $this->discount ?? 0,
            'idpricelist' => $this->idpricelist,
            $this->mergeWhen($pricelist, fn() => [
                'code_pricelist' => $pricelist->code,
                'name_pricelist' => $pricelist->name,
                'creation_pricelist' => $pricelist->creation_date,
                'validity_pricelist' => $pricelist->validity_date,
                'discounttype_pricelist' => $pricelist->discounttype,
                'max_desc_item_pricelist' => $pricelist->max_desc_item,
                'max_desc_global_pricelist' => $pricelist->max_desc_global,
            ]),
            'idproduct' => $this->idproduct,
            $this->mergeWhen($product, fn() => [
                'codeerp_product' => $product->code_erp,
                'codesystem_product' => $product->code_system,
                'name_product' => $product->name,

                'description_product' => $product->description,
                'cost_product' => $product->cost,
                'price_product' => $product->price,
                'alternativeprice_product' => $product->alternativeprice,
                'margin_product' => $product->margin,
                'offerprice_product' => $product->offerprice,
                'minimumstock_product' => $product->minimumstock,
                'maximumstock_product' => $product->maximumstock,

                'main_image_product' => $product->main_image,
                'optional_image1_product' => $product->optional_image1,
                'optional_image2_product' => $product->optional_image2,
                'optional_image3_product' => $product->optional_image3,
                'optional_image4_product' => $product->optional_image4,

                'idattributes_product' => $product->idattributes,
                'idspecificattributes_product' => $product->idspecificattributes,
                'iduses_product' => $product->iduses,
                'idspecificuses_product' => $product->idspecificuses,

                'idcointype_product' => $product->idcointype,
                'cointype_product' => $product->cointType->name ?? null,
                'idcategory_product' => $product->idcategory,
                'category_product' => $product->category->name ?? null,
                'idsubcategory_product' => $product->idsubcategory,
                'subcategory_product' => optional($product)->subcategory,
                'idspecificsubcategory_product' => $product->idspecificsubcategory,
                'specificsubcategory_product' => optional($product)->specificSubcategory,
                'idtype_product' => $product->idtype,
                'type_product' => optional($product)->type,
                'idsupplier_product' => $product->idsupplier,
                'idunitmeasure_product' => $product->idunitmeasure,
                'unitmeasure_product' => optional($product)->unitMeasure,
                'idunitmeasureoptional_product' => $product->idunitmeasureoptional,
                'idbusinessarea_product' => $product->idbusinessarea,
                'businessarea_product' => optional($product)->businessArea,
                'idclassification_product' => $product->idclassification,
                'classification_product' => optional($product)->classification,
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
