<?php

namespace App\Http\Resources;

use App\Models\Permissions;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PermissionsUserResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $user       = $this->relationLoaded('user') ? $this->whenLoaded('user') : null;
        $actions    = ['Lectura','Escritura','Edición','Eliminado'];

        $actionNames = collect($this->actions)->map(function ($actionIndex) use ($actions) {
            return $actions[$actionIndex - 1] ?? '';
        })->filter();

        return [
            'id'                    => $this->id,
            'iduser'                => $this->iduser,
            'idcompany'             => $this->idcompany,
            $this->mergeWhen($user, fn () => [
                'user_rut'          => $user->rut,
                'user_email'        => $user->email,
                'user_idcompany'    => $user->idcompany,
            ]),
            'permissions'           => $this->permissions,
            'detail_permissions'    => Permissions::whereIn('id', $this->permissions)->get(),
            'actions'               => $this->actions,
            'actions_name'          => $actionNames->toArray(),
            'status'                => $this->status
        ];
    }
}
