<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PayResource extends JsonResource
{
    public function toArray($request)
    {
        $user = $this->relationLoaded('user') ? $this->whenLoaded('user') : null;

        switch ($this->transaction_status) {
            case '0':
                $transactionName = 'En espera';
                break;

            case '1':
                $transactionName = 'Válido';
                break;

            case '2':
                $transactionName = 'Inválido';

                break;
        }

        $namePayType = 'Sin nombre';
        switch ($this->pay_type) {
            case '1':
                $namePayType = 'Ticket';
                break;

            case '2':
                $namePayType = 'Costo de membresía';
                break;

            default:
                $namePayType = 'Sin nombre';
                break;
        }

        return [
            'id'                        => $this->id,
            'pay_type'                  => $this->pay_type,
            'pay_type_name'             => $namePayType,
            'idregister'                => $this->idregister,
            'iduser'                    => $this->iduser,
            $this->mergeWhen($user, fn () => [
                'user_rut'              => $user->rut,
                'user_email'            => $user->email
            ]),
            'amount'                    => $this->amount,
            'purchase_identifier'       => $this->purchase_identifier,
            'transaction_status'        => $this->transaction_status,
            'transaction_status_name'   => $transactionName,
            'creation_date'             => $this->creation_date,
            'status'                    => $this->status
        ];
    }
}
