<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MembershipCostsResource extends JsonResource
{
    public function toArray($request)
    {
        $plans = $this->relationLoaded('plans') ? $this->whenLoaded('plans') : null;
        $membership = $this->relationLoaded('membership') ? $this->whenLoaded('membership') : null;

        return[
            'id'                => $this->id,
            'idplans'           => $this->idplans,
            $this->mergeWhen($plans, fn()=>[
                'plans'         => $plans->name
            ]),
            'idmembership'      => $this->idmembership,
            $this->mergeWhen($membership, fn()=>[
                'membership'    => $membership->name
            ]),
            'amount'            => 'CLP ' . number_format($this->amount),
            'date_start'        => $this->date_start,
            'date_end'          => $this->date_end,
            'UF'                => $this->UF,
            'status'            => $this->status
        ];
    }
}
