<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InternalGuideResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $store      = $this->relationLoaded('store') ? $this->whenLoaded('store') : null;
        $document   = $this->relationLoaded('document') ? $this->whenLoaded('document') : null;
        $supplier   = $this->relationLoaded('supplier') ? $this->whenLoaded('supplier') : null;
        $internalGuideDetail   = $this->relationLoaded('internalGuideDetail') ? $this->whenLoaded('internalGuideDetail') : null;

        return [
            'id'                        => $this->id,
            'correlative'               => $this->correlative,
            'date'                      => $this->date,
            'operation'                 => $this->operation,
            'idstore'                   => $this->idstore,
            $this->mergeWhen($store, fn () => [
                'store_code'            => $store->code,
                'store_iderp'           => $store->iderp,
                'store_name'            => $store->name,
                'store_description'     => $store->description
            ]),
            'iddocument'                => $this->iddocument,
            $this->mergeWhen($document, fn () => [
                'document_name'         => $document->name,
                'document_cod_erp'      => $document->cod_erp
            ]),
            'folio'                     => $this->folio,
            'idsupplier'                => $this->idsupplier,
            $this->mergeWhen($supplier, fn () => [
                'supplier_rut'          => $supplier->rut,
                'supplier_name_rz'      => $supplier->name_rz,
                'supplier_fantasy_name' => $supplier->fantasy_name,
            ]),
            'internal_number'           => $this->internal_number,
            'observation'               => $this->observation,
            'observation_cancellation'  => $this->observation_cancellation,
            'total'                     => $this->total,
            'detail'                    => InternalGuideDetailResource::collection($internalGuideDetail),
            'status'                    => $this->status
        ];
    }
}
