<?php

namespace App\Http\Resources;

use App\Models\DetInitialStep;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InitialStepResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $detInitialStep = $this->relationLoaded('detInitialStep') ? $this->whenLoaded('detInitialStep') : null;

        $plans = DetInitialStep::where('idinitial_step', $this->id)->active()->groupBy('key_plan')->pluck('key_plan') ?? [];

        return [
            'id' => $this->id,
            'description' => $this->description,
            'status' => $this->status,
            $this->mergeWhen($detInitialStep, fn () => [
                'detInitialStep' => DetInitialStepResource::collection($detInitialStep)
            ]),
            'plans' => $plans
        ];
    }
}
