<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DistrictResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $province = $this->relationLoaded('province') ? $this->whenLoaded('province') : null;

        return [
            'id' => $this->id,
            'code' => $this->code,
            'name' => $this->name,
            'idprovince' => $this->idprovince,
            $this->mergeWhen($province, fn () => [
                'code_province' => $province->code,
                'name_province' => $province->name,
                'iddepartment' => $province->iddepartment,
                'code_department' => $province->department->code,
                'name_department' => $province->department->name,
                'idcountry' => $province->department->idcountry,
                'code_country' => $province->department->country->code,
                'name_country' => $province->department->country->name
            ]),
            'status' => $this->status
        ];
    }
}
