<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DetailShoppingCartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $shoppingCart = $this->relationLoaded('shoppingCart') ? $this->whenLoaded('shoppingCart') : null;
        $product = $this->relationLoaded('product') ? $this->whenLoaded('product') : null;
        $productOrigin = $this->relationLoaded('productOrigin') ? $this->whenLoaded('productOrigin') : null;

        return [
            'id' => $this->id,
            'idshopping_cart' => $this->idshopping_cart,
            $this->mergeWhen($shoppingCart, fn () => [
                'iduser_created' => $shoppingCart->business_name,
                'idcustomer' => $shoppingCart->idcustomer,
                'net_total' => $shoppingCart->net_total,
                'gross_total' => $shoppingCart->gross_total,
                'type_document' => $shoppingCart->type_document,
                'type_sale' => $shoppingCart->type_sale,
                'payment_condition' => $shoppingCart->payment_condition,
                'way_to_pay' => $shoppingCart->way_to_pay,
                'idcompany' => $shoppingCart->idcompany,
            ]),
            'idpricelist_product' => $this->idpricelist_product,
            $this->mergeWhen($product, fn () => [
                'price' => $product->price,
                'cost' => $product->cost,
                'stock' => $product->stock,
                'subtotal' => $product->subtotal,
                'idpricelist' => $product->idpricelist,
                'code_pricelist' => $product->pricelist->code,
                'name_pricelist' => optional($product->pricelist)->name,
                'description_pricelist' => $product->pricelist->description,
                'creation_date_pricelist' => $product->pricelist->creation_date,
                'validity_date_pricelist' => $product->pricelist->validity_date,
                'document_state_pricelist' => $product->pricelist->document_state,
                'quantity_products_pricelist' => $product->pricelist->quantity_products,
                'total_pricelist' => $product->pricelist->total,
                'type_pricelist' => $product->pricelist->type,
                'discounttype_pricelist' => $product->pricelist->discounttype,
                'max_desc_item_pricelist' => $product->pricelist->max_desc_item,
                'validate_max_desc_item' => $product->pricelist->max_desc_item > 0 ? true : false,
                'max_desc_global_pricelist' => $product->pricelist->max_desc_global,
                'validate_max_desc_global' => $product->pricelist->max_desc_global > 0 ? true : false,
                'created_by_pricelist' => $product->pricelist->created_by,
                'idproduct' => $product->idproduct,
                'codeerp_product' => $product->product->code_erp,
                'codesystem_product' => $product->product->code_system,
                'name_product' => optional($product->product)->name,

                'description_product' => $product->product->description,
                'cost_product' => $product->product->cost,
                'price_product' => $product->product->price,
                'alternativeprice_product' => $product->product->alternativeprice,
                'margin_product' => $product->product->margin,
                'offerprice_product' => $product->product->offerprice,
                'minimumstock_product' => $product->product->minimumstock,
                'maximumstock_product' => $product->product->maximumstock,

                'main_image_product' => $product->product->main_image,
                'optional_image1_product' => $product->product->optional_image1,
                'optional_image2_product' => $product->product->optional_image2,
                'optional_image3_product' => $product->product->optional_image3,
                'optional_image4_product' => $product->product->optional_image4,

                'idattributes_product' => $product->product->idattributes,
                'idspecificattributes_product' => $product->product->idspecificattributes,
                'iduses_product' => $product->product->iduses,
                'idspecificuses_product' => $product->product->idspecificuses,

                'idcointype_product' => $product->product->idcointype,
                'cointype_product' => optional($product->product->cointType)->name,
                'idcategory_product' => $product->product->idcategory,
                'category_product' => optional($product->product->category)->name,
                'idsubcategory_product' => $product->product->idsubcategory,
                'subcategory_product' => optional($product->product)->subcategory,
                'idspecificsubcategory_product' => $product->product->idspecificsubcategory,
                'specificsubcategory_product' => optional($product->product)->specificSubcategory,
                'idtype_product' => $product->product->idtype,
                'type_product' => optional($product->product)->type,
                'idsupplier_product' => $product->product->idsupplier,
                'idunitmeasure_product' => $product->product->idunitmeasure,
                'unitmeasure_product' => optional($product->product)->unitMeasure,
                'idunitmeasureoptional_product' => $product->product->idunitmeasureoptional,
                'idbusinessarea_product' => $product->product->idbusinessarea,
                'businessarea_product' => optional($product->product)->businessArea,
                'idclassification_product' => $product->product->idclassification,
                'classification_product' => optional($product->product)->classification,
                'idcompany' => $product->idcompany,

            ]),
            $this->mergeWhen(!$product, function () use ($product, $productOrigin) {
                $result = [];

                # Agregar $productOrigin cuando $product es inválido
                if (!$product && $productOrigin) {
                    $result = [
                        'idproduct' => $productOrigin->id,
                        'codeerp_product' => $productOrigin->code_erp,
                        'codesystem_product' => $productOrigin->code_system,
                        'name_product' => optional($productOrigin)->name,
                        'description_product' => $productOrigin->description,
                        'cost_product' => $productOrigin->cost,
                        'price_product' => $productOrigin->price,
                        'alternativeprice_product' => $productOrigin->alternativeprice,
                        'margin_product' => $productOrigin->margin,
                        'offerprice_product' => $productOrigin->offerprice,
                        'minimumstock_product' => $productOrigin->minimumstock,
                        'maximumstock_product' => $productOrigin->maximumstock,
                    ];
                }
                return $result;
            }),
            'quantity' => $this->quantity,
            'price' => $this->price,
            'offer_price' => $this->offer_price,
            'discount' => $this->discount,
            'validate_discount' => $this->discount > 0 ? true : false,
            'discounttype' => $this->discounttype,
            'gross_subtotal' => $this->gross_subtotal,
            'net_subtotal' => $this->net_subtotal,
            'status' => $this->status
        ];
    }
}
