<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DetailPriceListSalesmanResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $pricelist = $this->relationLoaded('pricelist') ? $this->whenLoaded('pricelist') : null;
        $salesman = $this->relationLoaded('salesman') ? $this->whenLoaded('salesman') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'idpricelist' => $this->idpricelist,
            $this->mergeWhen($pricelist, fn() => [
                'code'              => $pricelist->code,
                'pricelist'         => $pricelist->name,
                'description'       => $pricelist->description,
                'creation_date'     => $pricelist->creation_date,
                'validity_date'     => $pricelist->validity_date,
                'document_state'    => $pricelist->document_state,
                'quantity_products' => $pricelist->quantity_products,
                'total'             => $pricelist->total,
                'type'              => $pricelist->type,
                'discounttype'      => $pricelist->discounttype,
                'minimumdiscount'   => $pricelist->minimumdiscount,
                'maximumdiscount'   => $pricelist->maximumdiscount,
                'created_by'        => $pricelist->created_by
            ]),
            'idsalesman' => $this->idsalesman,
            $this->mergeWhen($salesman, fn() => [
                'rut_salesman' => $salesman->rut,
                'name_salesman' => $salesman->name . " " . $salesman->surname,
                'email_salesman' => $salesman->email,
                'phone_salesman' => $salesman->phone
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
