<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DetailPriceListCustomerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $pricelist = $this->relationLoaded('pricelist') ? $this->whenLoaded('pricelist') : null;
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'idpricelist' => $this->idpricelist,
            $this->mergeWhen($pricelist, fn() => [
                'code'              => $pricelist->code,
                'pricelist'         => $pricelist->name,
                'description'       => $pricelist->description,
                'creation_date'     => $pricelist->creation_date,
                'validity_date'     => $pricelist->validity_date,
                'document_state'    => $pricelist->document_state,
                'quantity_products' => $pricelist->quantity_products,
                'total'             => $pricelist->total,
                'type'              => $pricelist->type,
                'discounttype'      => $pricelist->discounttype,
                'minimumdiscount'   => $pricelist->minimumdiscount,
                'maximumdiscount'   => $pricelist->maximumdiscount,
                'created_by'        => $pricelist->created_by
            ]),
            'idcustomer' => $this->idcustomer,
            $this->mergeWhen($customer, fn() => [
                'rut_customer' => $customer->rut,
                'name_customer' => $customer->name_rz,
                'email_customer' => $customer->email,
                'phone_customer' => $customer->phone
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
