<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DetailPriceListBranchOfficeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $pricelist = $this->relationLoaded('pricelist') ? $this->whenLoaded('pricelist') : null;
        $branchOffice = $this->relationLoaded('branchOffice') ? $this->whenLoaded('branchOffice') : null;
        $company = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;

        return [
            'id' => $this->id,
            'idpricelist' => $this->idpricelist,
            $this->mergeWhen($pricelist, fn() => [
                'code'              => $pricelist->code,
                'pricelist'         => $pricelist->name,
                'description'       => $pricelist->description,
                'creation_date'     => $pricelist->creation_date,
                'validity_date'     => $pricelist->validity_date,
                'document_state'    => $pricelist->document_state,
                'quantity_products' => $pricelist->quantity_products,
                'total'             => $pricelist->total,
                'type'              => $pricelist->type,
                'discounttype'      => $pricelist->discounttype,
                'minimumdiscount'   => $pricelist->minimumdiscount,
                'maximumdiscount'   => $pricelist->maximumdiscount,
                'created_by'        => $pricelist->created_by
            ]),
            'idbranchoffice' => $this->idbranchoffice,
            $this->mergeWhen($branchOffice, fn() => [
                'branchOffice' => $branchOffice->name,
                'assignmenttype' => $branchOffice->assignmenttype,
                'idproductlist' => $branchOffice->idproductlist,
                'idofficetype' => $branchOffice->idofficetype,
                'officetype' => $branchOffice->typeOffice->name,
                'iddistrict' => $branchOffice->iddistrict,
                'district' => $branchOffice->district->name,
                'idprovince' => $branchOffice->idprovince,
                'province' => $branchOffice->province->name,
                'iddepartment' => $branchOffice->iddepartment,
                'department' => $branchOffice->department->name,
                'idcountry' => $branchOffice->idcountry,
                'country' => $branchOffice->country->name
            ]),
            'idcompany' => $this->idcompany,
            $this->mergeWhen($company, fn() => [
                'company' => $company->business_name,
                'rut_company' => $company->rut
            ]),
            'status' => $this->status
        ];
    }
}
