<?php

namespace App\Http\Resources;

use App\Models\Membership;
use App\Models\MembershipPlans;
use App\Models\Professional;
use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;
use Lcobucci\JWT\Token\Plain;

class DetailMembershipPaymentResourcePayment extends JsonResource
{
    public function toArray($request)
    {
        $membershipCost = $this->relationLoaded('membershipCosts') ? $this->whenLoaded('membershipCosts') : null;
        $plan         = MembershipPlans::where('id', $membershipCost->idplans)->first();
        $membership   = Membership::where('id', $membershipCost->idmembership)->first();

        return [
            'id' => $this->id,
            $this->mergeWhen($membershipCost, fn () => [
                'idplan'        => $plan->id,
                'plan'          => $plan->name,
                'idmembership'  => $membership->id,
                'membership'    => $membership->name,
                'amount'        => 'CLP ' . number_format($membershipCost->amount)
            ]),
            'idpay'             => $this->idpay,
            'payment_date'      => date("Y-m-d", strtotime($this->payment_date)),
            'status_page'       => $this->status_page,
            'status_invoice'    => $this->status_invoice,
            'url_invoice'       => $this->url_invoice,
            'payment_date_end'  => date("Y-m-d", strtotime($this->payment_date_end)),
            'status'            => $this->status
        ];
    }
}
