<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DetailMembershipPaymentResource extends JsonResource
{
    public function toArray($request)
    {
        $company            = $this->relationLoaded('company') ? $this->whenLoaded('company') : null;
        $membershipCosts    = $this->relationLoaded('membershipCosts') ? $this->whenLoaded('membershipCosts') : null;
        $pay                = $this->relationLoaded('pay') ? $this->whenLoaded('pay') : null;

        return [
            'id'                    => $this->id,
            'idcompany'             => $this->idcompany,
            $this->mergeWhen($company, fn () => [
                'rut'               => $company->rut,
                'business_name'     => $company->business_name,
                'email'             => $company->email,
                'idmembership'      => $company->idmembership
            ]),
            'idmembershipcosts'     => $this->idmembershipcosts,
            $this->mergeWhen($membershipCosts, fn () => [
                'idplans'           => $membershipCosts->idplans,
                'plans'             => $membershipCosts->plans->name,
                'idmembership'      => $membershipCosts->idmembership,
                'membership'        => $membershipCosts->membership->name,
                'erp_code'          => $membershipCosts->cod_erp,
                'amount'            => 'CLP ' . number_format($membershipCosts->amount),
                'date_start'        => $membershipCosts->date_start,
                'date_end'          => $membershipCosts->date_end,
            ]),
            'idpay'                 => $this->idpay,
            $this->mergeWhen($pay, fn () => [
                'amount'            => $pay->amount,
                'purchase_identifier'   => $pay->purchase_identifier,
            ]),
            'payment_date'          => $this->payment_date,
            'payment_date_end'      => $this->payment_date_end,
            'status'                => $this->status
        ];
    }
}
