<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DetInitialStepResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $initialStep = $this->relationLoaded('initialStep') ? $this->whenLoaded('initialStep') : null;

        return [
            'id' => $this->id,
            'idinitial_step' => $this->idinitial_step,
            $this->mergeWhen($initialStep, fn () => [
                'initialStep' => $initialStep->description
            ]),
            'key_plan' => $this->key_plan,
            'order' => $this->order,
            'status' => $this->status
        ];
    }
}
